	% EXEMPLE 5.19
	clear all
	wcT = 0.4*pi;	wsT = 0.5*pi;	dc = 0.05;	ds = 0.01;	
	N = 32;	M = N/2+1;	m = 1:M;	t = 1;
	Kp = 500; Ks = 500;
	wT = [linspace(0, wcT, Kp) linspace(wsT, pi, Ks)];
	D = [ones(1, Kp) zeros(1,Ks)];
	W = [ones(1, Kp)/dc ones(1,Ks)/ds];
	A = [TRIGMAT(t, m, wT) -1./W'];
	A = [A' [-TRIGMAT(t, m, wT) -1./W']']';
	b = [D -D]';
	c = [zeros(1,M) 1]';
	%  x = lp(c, A, b);	% Old verson
	x = linprog(c, A, b);
	h = [0.5*fliplr(x(2:M)') x(1) 0.5*x(2:M)'];
	wT = linspace(0, pi, 1000); H = freqz(h,1,wT);
	subplot('position', [0.10 0.4 0.86 0.5])
	PLOT_MAG_Z_DB(wT, H, pi, 60, 'H')
	axes('position',[0.63 0.67 0.25 0.12]);
	wT = linspace(0, 0.4*pi, 1000); H = freqz(h,1,wT);
	PLOT_MAG_Z_LS(wT, H, 0.95, 1.05, 'H')
	
